////////////////////////////////////////////////////////////
// rhythm generator v3.2
// oswald berthold, 200710
//
(
b = Bus.audio(s, 1);
SynthDef(\selfmod, {
	|initfreq(1.0), phase(0.0), moddepth1(1.0), modoffset1(1.0), moddepth2(1.0), modoffset2(1.0), fout(0)|
	// declare vars
	var x1, x2, f1, f2, t1;
	// define functions for feedback mapping, linear case
	f1 = {|val| val * Lag.kr(moddepth1, 0.2) + Lag.kr(modoffset1, 1)};
	f2 = {|val| val * Lag.kr(moddepth2, 0.2) + Lag.kr(modoffset2, 1)};
	// get fb value
	m = InFeedback.ar(fout, 1); // Delay1.ar(x, mul: moddepth, add: modoffset);
	// define oscillators
	x1 = SinOsc.ar(f1.value(m), phase, 0.5, 0);
	x2 = SinOsc.ar(f2.value(x1), 0, 1.0, 0);
	// extract impulse from oscillation
	t1 = Trig1.ar(x2 > 0.8, (x1+1)*10/SampleRate.ir);
	// send delay between pulses
	SendTrig.ar(t1, 0, Timer.ar(Delay1.ar(t1)));
	Out.ar(fout, x2);
	// play something too
	Out.ar(0, t1);
}).send(s);
)

// storing the delays between impulses
~dts = Array.new(0);

(
// receive SendTrig impulse intervals
o = OSCresponder(s.addr,'/tr',{ arg time,responder,msg;
	[time,responder,msg].postln;
	~dts = ~dts.add(msg[3]);
});
o.add;
)

// play the synth
x = Synth(\selfmod, [\fout, b.index, \moddepth1, 7.33, \modoffset1, 10, \moddepth2, 10, \modoffset2, 1.33]);
~dts.postcs;
~dts.size;

// save the Timer values in a file for distance-distance plotting
~fh = File.new("chaos03.1.abstaende.dat", "w");
~dts.do {|val|
	~fh.putString(val.asString ++ "\n");
};
~fh.close;

(
// record it
// prepare for recording
s.recChannels_(1);
s.recHeaderFormat_('wav');
s.recSampleFormat_('int16');
s.prepareForRecord("rhythmus.wav");


// record
s.record;
x = Synth(\selfmod, [\fout, b.index, \moddepth1, 7.33, \modoffset1, 10, \moddepth2, 10, \modoffset2, 1.33]);
{s.stopRecording;}.defer(60);
)


s.jscope(bufsize: 2048);

x.set(\modoffset1, 10.1)
x.set(\moddepth1, 7.33)
x.set(\modoffset2, 10.77)
x.set(\moddepth2, 10)